/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import java.awt.Color;
import java.util.Calendar;

public final class Colorer {
    public static final Color REBUILD_BG_COLOR = new Color(117, 207, 106);
    public static final Color OFFLINE_BG_COLOR = Color.LIGHT_GRAY;
    private static Color GOR_SOON_COLOR = new Color(101, 137, 200);
    private static Color GOR_OK_COLOR = new Color(101, 137, 25);
    private static Color GOR_LATE_COLOR = new Color(160, 0, 0);
    private static Color GOR_RANDOM_COLOR1 = GOR_SOON_COLOR;
    private static Color GOR_RANDOM_COLOR2 = new Color(255 - GOR_RANDOM_COLOR1.getRed(), 255 - GOR_RANDOM_COLOR1.getGreen(), 255 - GOR_RANDOM_COLOR1.getBlue());

    private Colorer() {
        throw new UnsupportedOperationException();
    }

    public static Color getForegroundColor(Color bg) {
        if (0.3 * (double)bg.getRed() + 0.59 * (double)bg.getGreen() + 0.11 * (double)bg.getBlue() < 160.0) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    public static Color getGorColorByProduct(GeneralizedOrderRequest gor) {
        return Colorer.getColorByHash(gor.getProduct().getName().hashCode(), GOR_RANDOM_COLOR1, GOR_RANDOM_COLOR2);
    }

    public static Color getGorColorByState(GeneralizedOrderRequest gor, int deltaAmount, int deltaUnit) {
        long end = gor.getEndDate();
        long due = gor.getDueDate();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(gor.getDueDate());
        c.add(deltaUnit, -deltaAmount);
        long dueAdvance = c.getTimeInMillis();
        if (GeneralizedRequest.isDateValid(end) && GeneralizedRequest.isDateValid(due) && GeneralizedRequest.isDateValid(dueAdvance)) {
            if (end < dueAdvance) {
                return GOR_SOON_COLOR;
            }
            if (end < due) {
                return GOR_OK_COLOR;
            }
        }
        return GOR_LATE_COLOR;
    }

    public static Color getColorByHash(int hashCode, Color c1, Color c2) {
        int steps = 128;
        int gorsteps = Math.abs(hashCode) % 128;
        double dr = (double)(c2.getRed() - c1.getRed()) / 128.0;
        double dg = (double)(c2.getGreen() - c1.getGreen()) / 128.0;
        double db = (double)(c2.getBlue() - c1.getBlue()) / 128.0;
        return new Color((int)Math.floor((double)c1.getRed() + (double)gorsteps * dr), 255 - (int)Math.floor((double)c1.getGreen() + (double)gorsteps * dg), (int)Math.floor((double)c1.getBlue() + (double)gorsteps * db));
    }
}

